function TS_vector = extract_cds_field_TS(CDX, fieldname, sub_cell_field)
% --------------------------------------------------------------------------------------------------
% For a given fieldname, extract the values of the individual credit default swaps and convert into
% time series, and store time series in a TS_vector
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% fieldname         ... name of field of interest
% date              ... values for which field to extract
% sub_cell_field    ... optional sub-field
% --------------------------------------------------------------------------------------------------
% sample call: extract_cds_field_TS(CDX_NA_IG2, 'intensity_P');
%              extract_cds_field_TS(CDX_NA_IG2, 'market_price', 3);
% --------------------------------------------------------------------------------------------------

TS_vector = {};
for i=1:length(CDX.portfolio)
    % Extract values for CDS
    cds = CDX.portfolio(i);
    if (~isfield(cds, fieldname))
        TS_vector{i,1} = [];
        continue;
    end
    if isempty(cds.(fieldname))
        TS_vector{i,1} = [];
        continue;
    end
    if (nargin <= 2)
        TS = struct('dates', cds.dates{1}, 'values', cds.(fieldname));
        TS_vector{i,1} = TS;
    else
        if isempty(cds.(fieldname){sub_cell_field})
            TS_vector{i,1} = [];
            continue;
        end
        TS = struct('dates', cds.dates{1}, 'values', cds.(fieldname){sub_cell_field});
        TS_vector{i,1} = TS;
    end
end